<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-plugin-content.php                                 */
/* Author:      Paul Waite                                              */
/* Description: Manage Axyl plugin content. Plugin content is an 'item' */
/*              of content, eg. a Main Menu, or a Forum, which can be   */
/*              'plugged in' to an Axyl plugin area.                    */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("maintainer-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Plugin Content", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// User type form widget..
$gtype = new form_combofield("generator_type", "Generator type");
$gtype->setclass("axcombo");
$gtype->additem("cm",    "CM layout");
$gtype->additem("func",  "Standard function");
$gtype->additem("defer", "Deferred function");
$gtype->additem("lit",   "Literal string");
$gtype->additem("file",  "File content");

$gen = new form_memofield("generator", "Generator");
$gen->setclass("axmemo");
$gen->setstyle("width:300px;height:100px;");


// User type form widget..
$maint = new maintainer("Plugin Content", "ax_plugin_content");
$maint->set_allowed_groups("Admin,Editor");
$maint->setalign("center");
$maint->view_primary_keys();
$maint->set_formfieldwidget("generator", $gen);
$maint->set_formfieldwidget("generator_type", $gtype);

$RESPONSE->plugin("MAIN_CONTENT", $maint->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>