<?php
/************************************************************************/
/* CATALYST Php Source Code                                             */
/* Copyright (C) 2002 Paul Waite                                        */
/*                                                                      */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    /var/cm/axyl-tour-12.10.php                             */
/* Author:      Paul Waite                                              */
/* Description: Php webpage with Content Management Layout.             */
/*                                                                      */
/*              If you want to create a new content managed webpage     */
/*              then copy this one, and change your LAYOUT_ID to a      */
/*              unique name (possibly the title, as suggested).         */
/*                                                                      */
/************************************************************************/

include_once("application.php");
include_once("layout-defs.php");

// -----------------------------------------------------------------------
// Content Managed Webpage
// Set these as appropriate:
$PAGE_TITLE = "Axyl Tour: Section 12.10 - Debugging Your Code";
$LAYOUT_ID  = "86_Axyl_Tour:_Section_12.10_-_Debugging_Your_Code";    // Must be unique
$TEMPLATE   = "tour";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($PAGE_TITLE, $TEMPLATE, $theme);

//debug_on(DBG_DUMP|DBG_DIAGNOSTIC|DBG_SQL|DBG_TABLES);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// -----------------------------------------------------------------------
// MAIN CONTENT
$RESPONSE->plugin("MAIN_CONTENT", "<!--LAYOUTID=\"$LAYOUT_ID\"-->");

// #######################################################################
// OUTPUT..
$RESPONSE->send();
?>
