#ifndef OBJ_H
#define OBJ_H

#include <glib.h>


typedef struct _obj_struct		obj_struct;


/*
 *	Scan options:
 */
typedef enum {

	AVSCAN_OPT_RECURSIVE			= (1 << 0),
	AVSCAN_OPT_EXECUTABLES_ONLY		= (1 << 1),
	AVSCAN_OPT_IGNORE_LINKS			= (1 << 2),

	/* The following flags are for objects stored on the
	 * Results List
	 */
	AVSCAN_OPT_INFECTED			= (1 << 8)

} avscan_options;


/*
 *	Object:
 */
struct _obj_struct {

	gchar		*name,
			*path;
	avscan_options	options;
	gulong		last_runned;

};
#define OBJ(p)		((obj_struct *)(p))


extern obj_struct *ObjNew(void);
extern obj_struct *ObjCopy(const obj_struct *obj);
extern void ObjDelete(obj_struct *obj);

extern GList *ObjDDEBufferParse(const guint8 *buf, const gint buf_len);
extern guint8 *ObjDDEBufferAppend(
        guint8 *buf, gint *buf_len_rtn,
        const obj_struct *obj  
);
extern GList *ObjDDEBufferParsePath(const guint8 *buf, const gint buf_len);
extern guint8 *ObjDDEBufferAppendPath(
        guint8 *buf, gint *buf_len_rtn, 
        const obj_struct *obj
);


#endif	/* OBJ_H */
