
// make sure the right function strerror_r is used
#define _XOPEN_SOURCE 600
#include <string.h>
#include <errno.h>

#include "debug.h"

#include "aclogger.h"
#include "acfg.h"
#include "lockable.h"
#include "filereader.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glob.h>

#include <vector>
#include <iostream>

#include <stdio.h>

using namespace MYSTD;

namespace aclog
{

FILE *fErr(NULL), *fStat(NULL);
static pthread_mutex_t mx = PTHREAD_MUTEX_INITIALIZER;

bool open()
{
	if(acfg::logdir.empty())
		return true;
	
	string apath(acfg::logdir+"/apt-cacher.log"), epath(acfg::logdir+"/apt-cacher.err");
	
	fErr = fopen(epath.c_str(), "a");
	fStat = fopen(apath.c_str(), "a");

	return fStat && fErr;
}


void transfer(bool bDirIn, uint64_t nCount, const char *szClient, const char *szPath)
{
	if(!fStat)
		return;
	lockguard g(&mx);

	fprintf(fStat, acfg::verboselog ? "%lu|%c|%"PRIu64"|%s|%s\n" : "%lu|%c|%"PRIu64"\n",
			(unsigned long) time(NULL), bDirIn ? 'I' : 'O', nCount,
					szClient, szPath);

	if(acfg::debug)
		fflush(fStat);
}

void misc(const string & sLine)
{
	if(!fStat)
		return;
	lockguard g(&mx);

	fprintf(fStat, "%lu|M|%s\n", (unsigned long) time(NULL), sLine.c_str());
	
	if(acfg::debug)
		fflush(fStat);
}

/*
 void aclogger::err(MYSTD::string &client, MYSTD::string &msg) {
 err(client.c_str(), msg.c_str());
 }
 */

void err(const char *msg, const char *client)
{
	if(!fErr)
		return;
	
	lockguard g(&mx);

	static char buf[32];
	const time_t tm=time(NULL);
	ctime_r(&tm, buf);
	buf[24]=0;
	if (client)
		fprintf(fErr, "%s|%s: %s\n", buf, client, msg);
	else
		fprintf(fErr, "%s|%s\n", buf, msg);
#ifdef DEBUG
	if(acfg::debug>=10)
	{
		fprintf(stderr, "%s|%s\n", buf, msg);
		fflush(stderr);
	}
#endif
	fflush(fErr);
	
}

void flush()
{
	lockguard g(&mx);
	if(fErr)
		fflush(fErr);
	if(fStat)
		fflush(fStat);
}

void reopen()
{
	lockguard g(&mx);
	if (fErr)
		forceFclose(fErr);
	if (fStat)
		forceFclose(fStat);
	aclog::open();
}

void close()
{
	lockguard g(&mx);
	if(acfg::debug>4) cerr << "Closing logs...\n";
	if(fErr) 
	{
		forceFclose(fErr);
		fErr=NULL;
	}
	if(fStat) 
	{
		forceFclose(fStat);
		fStat=NULL;
	}
}


#define DAYSECONDS (3600*24)
#define WEEKSECONDS (DAYSECONDS * 7)

void GetStats(vector<tRowData> & out)
{
	string sDataFile=acfg::cachedir+sPathSep+"_stats_dat";

	
	out.clear();
	time_t now=time(NULL);
	
	for(int i=0; i<7; i++)
	{
		tRowData d;
		d.to=now - i*DAYSECONDS;
		d.from=d.to - DAYSECONDS;
		out.push_back(d);
	}
	
#warning NOTE: stats cache disabled, restore it later?
#if 0
	struct stat statbuf;
	
	if ( 0!= stat(sDataFile.c_str(), &statbuf) 
			|| statbuf.st_mtime < time(NULL)-86000
	   )

	{ // needs to be created/updated
		
#endif
		glob_t globbuf;

		memset(&globbuf, 0, sizeof(glob_t));
		glob((acfg::logdir+"/apt-cacher*.log").c_str(), GLOB_DOOFFS | GLOB_NOSORT,
				NULL, &globbuf);

		//cout << "wo? " << (acfg::logdir+"/*.log.*").c_str() <<endl;
		
		for (unsigned int i=0; i<globbuf.gl_pathc; i++)
		{
			if(acfg::debug)
				cerr << "Reading log file: " << globbuf.gl_pathv[i] <<endl; 
			filereader reader;
			if (!reader.OpenFile(globbuf.gl_pathv[i]))
			{
				aclog::err("Error opening a log file");
				continue;
			}
			string sLine;
			tStrVec tokens;

			while(reader.GetOneLine(sLine))
			{
				// cout << "got line: " << sLine <<endl;
				tokens.clear();
				if(Tokenize(sLine, "|", tokens)<3)
					 continue;
				 
				 // cout << "having: " << tokens[0] << ", " << tokens[1] << ", " << tokens[2]<<endl;
				 
				 time_t when=strtoul(tokens[0].c_str(),0,10);
				 if(when > out.front().to || when < out.back().from)
					 continue;
				 
				 for(vector<tRowData>::reverse_iterator it=out.rbegin();
				 it!=out.rend(); 
				 it++)
				 {
					  if(when < it->from || when > it->to)
						  continue;

						 unsigned long dcount=strtoul(tokens[2].c_str(),0,10);
						 switch(* tokens[1].c_str()) {
						 case('I'): 
							 it->byteIn+=dcount;
						 it->reqIn++;
						 break;
						 case('O'): 
							 it->byteOut+=dcount;
						 it->reqOut++;
						 break;
						 default:
							 continue;
						 }
	  
				 }
				 
				 
			}
		}
		globfree(&globbuf);
		
#if 0
		// Normalize data and repack for user 
		
		map<time_t,tempCounts>::iterator it;
		for(it=mapPeriod2InOut.begin(); it!=mapPeriod2InOut.end(); it++)
		{
			tRowData data;
			data.count=it->second.first+it->second.second;
			data.ratioSent=double(it->second.second)/double(data.count);
			if(it->first < RANGEMARK)
				data.from=data.to= now - it->first * 24 * 3600;
			else
			{
				data.to = now - (it->first-RANGEMARK)*7*24*3600;
				data.from=data.to-7*24*3600;
			}
			out.push_back(data);
			
		}
	}
	else
	{ // deserialize
		filereader reader;
		string sLine;
		tStrVec tokens;
		
		if(!reader.OpenFile(sDataFile))
		{
			aclog::err("Error opening stats file");
			return;
		}
		while(reader.GetOneLine(sLine) && Tokenize(sLine, SPACECHARS, tokens)==4)
		{
			tRowData data;
			data.from=strtoul(tokens[0].c_str(),0,10);
			data.to=strtoul(tokens[1].c_str(),0,10);
			data.count=atof(tokens[2].c_str());
			data.ratioSent=atof(tokens[3].c_str());
			out.push_back(data);
			tokens.clear();
		}
	}
#endif
}
	
errnoFmter::errnoFmter()
{
	char buf[32];
	buf[0]=buf[31]=0x0;
	msg=&buf[0];

#ifdef _GNU_SOURCE
#warning COMPILER BUG DETECTED -- _GNU_SOURCE was preset in C++ mode
	msg=strerror_r(errno, buf, sizeof(buf)-1);
#else
	strerror_r(errno, buf, sizeof(buf)-1);
#endif
}

}

